#!/usr/bin/env python3

import os
import typer
import random
import json

from typing import Optional, List

app = typer.Typer()


@app.command()
def complete(comp_point: int, comp_line_parts: List[str]):
    comp_line_parts = comp_line_parts[1:]  # 第一个元素必定为'premium_doctor'，于补全无用
    comp_line_parts = comp_line_parts or ['']

    first_word = comp_line_parts[0]
    last_word = comp_line_parts[-1]
    options = ['hello', 'world']

    if first_word in options:
        # comp_line == 'premium_doctor hello'
        result = []

    elif last_word == '':
        # comp_line == 'premium_doctor '
        result = options

    else:
        # comp_line == 'premium_doctor h'
        result = [x for x in options if x.startswith(last_word)]

    with open('/tmp/complete-debug-info.txt', 'w') as f:
        f.write(f'comp_point: {comp_point}\n')
        f.write(f'comp_line: {comp_line_parts}\n')
        f.write(f'result: {result}\n')

    print(' '.join(result), end='')


@app.command()
def ps1():
    ctx = get_context()
    items = [
        f'uid: {ctx["user_id"]}',
        f'on {ctx["app_code"]}-{ctx["platform"]} v{ctx["app_version"]}',
    ]
    ps1 = ' '.join(items)
    set_color = '\033[0;32m'
    reset_all = '\033[0m'
    print(f'{set_color}{ps1}{reset_all}', end='')


@app.command()
def switch_context(user_id: int):
    # mock data
    app_version = f'4.32.{random.randint(0, 10)}'
    app_code = f'app{random.randint(0, 3)}'
    platform = 'ios' if random.random() > 0.5 else 'android'

    context = {
        'user_id': user_id,
        'app_version': app_version,
        'app_code': app_code,
        'platform': platform,
    }

    context_path = os.path.expanduser('~/.config/premium_doctor/context.json')
    with open(context_path, 'w') as f:
        json.dump(context, f, indent=4)


def get_context():
    context_path = os.path.expanduser('~/.config/premium_doctor/context.json')
    with open(context_path) as f:
        return json.load(f)


@app.command()
def end_sale():
    print('end_sale success!')


@app.command()
def move_sale_days(days: Optional[int] = -1):
    ctx = get_context()
    print(f'uid: {ctx["user_id"]}, move_sale_days {days} days success!')


@app.command()
def view_sale_kv():
    print('Current campaign: xxx')
    print('Start At: 2023-03-13 17:38:00')
    print('End At:   2023-03-15 17:38:00')


@app.command()
def extend_premium(seconds: Optional[int] = 1800):
    print(f'extend_premium {seconds} seconds success!')


@app.command()
def remove_premium():
    print('remove_premium success!')


if __name__ == '__main__':
    app()

